<?php

namespace VM\AdminBundle\Controller;

use Entities\User;
use FOS\RestBundle\Controller\Annotations\View;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use VM\AdminBundle\Services\ApiGetter;
use VM\AdminBundle\Services\RDFExportGeneratorService;
use VM\AdminBundle\Services\ResetGroupService;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\UserGroups;
use Symfony\Component\HttpFoundation\Response;

class TeachersController extends AbstractController
{
    /**
     * @View(serializerGroups={"details"})
     */
    public function createTeacherAction()
    {
        if (false === $this->get('security.context')->isGranted('ROLE_TEACHER_CREATOR')) {
            throw new AccessDeniedException('Użytkownik nie ma prawa wykonywania tej akcji.');
        }

        $firstname = $this->getRequest()->request->get('firstname');
        $lastname = $this->getRequest()->request->get('lastname');
        $email = $this->getRequest()->request->get('email');

        $SsoCommunication = $this->getSsoCommunication();

        try
        {
            if(!empty($firstname) && !empty($lastname) && !empty($email))
            {
                $defaultPassword = md5(sha1(rand(1, 1000000)));
                $response = $SsoCommunication->registerUser($firstname, $lastname, $email, $defaultPassword);

                $User = new \VM\ApiBundle\Entity\User();
                $User->setGroup(null);
                $User->setUsername($email);
                $User->setName($firstname);
                $User->setSurname($lastname);
                $User->setEmail($email);
                $User->setExternalId($response['user_id']);
                $User->setRoles(array('ROLE_TEACHER'));

                $this->getDoctrine()->getManager()->persist($User);

                $SsoCommunication->registrationConfirm($User->getExternalId(), $response['confirmation_token']);
                $loginData = $SsoCommunication->loginUser($User->getEmail(), $defaultPassword);
                $SsoCommunication->userSetRoles($response['user_id'], $loginData['token'], array('ROLE_TEACHER'));
                $SsoCommunication->logoutUser($response['user_id'], $loginData['token']);
                $result = $SsoCommunication->userGeneratePasswordRecoveryToken($User->getEmail());
                $this->getDoctrine()->getManager()->flush();

                $message = \Swift_Message::newInstance()
                    ->setSubject('Rejestracja w Grze Biznesowej')
                    ->setFrom($this->container->getParameter('mailer_from'))
                    ->setTo($User->getEmail())
                    ->setBody(
                        $this->renderView(
                            'VMAdminBundle:Mailer:registration_teacher_email.html.twig',
                            array(
                                'User' => $User,
                                'result' => $result,
                                'Teacher' => $this->getUser()
                            )
                        )
                    )
                ;
                $this->get('mailer')->send($message);
            }
            else
            {
                throw new \Exception('Brak wymaganych danych do założenia konta nauczyciela.');
            }
        }
        catch(\Exception $exception)
        {
            return new Response(json_encode(array('message' => $exception->getMessage(), 'code' => 500)), 500);
        }

        return true;
    }

}
